//------------------------------------//
// Info button
//------------------------------------//

var infoBody = null;
var infoButton = null;

// 'i'画像のボタンを作ります
function createInfoButton(body, div, color) {
  // スタイルを設定します
  var backgroundUrl = "file:///System/Library/WidgetResources/ibutton/" + color + "_i.png";
  div.setAttribute("style", "opacity: 0.0; background: url(" + backgroundUrl + ") no-repeat top left;");
  
  // イベントハンドラを設定します
  body.addEventListener("mouseover", infoBodyMouseOver, true);
  body.addEventListener("mouseout", infoBodyMouseOut, true);
  
  // 渡されたノードを保持します
  infoBody = body;
  infoButton = div;
}

// マウスが入ってきたときのイベントハンドラです
function infoBodyMouseOver(event) {
  // フェードインアニメーションを開始します
  infoButtonStartAnimationInDirection(1);
}

function infoBodyMouseOut(event) {
  // フェードアウトアニメーションを開始します
  infoButtonStartAnimationInDirection(0);
}

// アニメーションのためのデータです
var infoAnimator = {
  // fromValue、toValue、currentValueは、'i'画像のopacityを表します
  
  // opacityの開始値です
  fromValue: 0.0, 
  // opacityの最終値です
  toValue: 1.0, 
  // opacityの現在値です
  currentValue: 0.0, 
  
  // アニメーションにかかる時間です。単位はミリ秒です
  duration: 500, 
  
  // フェードインかフェードアウトかを示します
  direction: 0, 
  // アニメーションの開始時間です
  startTime: 0, 
  // アニメーションのフレームレートです
  frameRate: 13, 
  // アニメーションで使うタイマーです
  timer: null
};

// フェードイン／アウトアニメーションを開始します
function infoButtonStartAnimationInDirection(direction) {
  if (direction != infoAnimator.direction) {
    // 現在のアニメーションを停止します
    infoButtonStopAnimate();
    
    // 開始時間を設定します
    infoAnimator.startTime = (new Date).getTime() - infoAnimator.frameRate;
    // opacityの開始値を設定します
    infoAnimator.fromValue = infoAnimator.currentValue;
    // フェードインかフェードアウトに合わせて、opacityの最終地を設定します
    direction == 0 ? infoAnimator.toValue = 0.0 : infoAnimator.toValue = 1.0;
    // フェードインかフェードアウトかを記憶しておきます
    infoAnimator.direction = direction;
    
    // タイマーをスタートします
    infoAnimator.timer = setInterval("infoButtonStepNextFrame();", infoAnimator.frameRate);
  }
}

// アニメーションを停止します
function infoButtonStopAnimate() {
  if (infoAnimator.timer) {
    // タイマーを停止します
    clearInterval(infoAnimator.timer);
    infoAnimator.timer = null;
  }
}

// アニメーションのためのハンドラです
// フェードイン／アウトを行います
function infoButtonStepNextFrame() {
  // アニメーション開始からの経過時間を計算します
  var elapsed = (new Date).getTime() - infoAnimator.startTime;
  if (elapsed < 0) elapsed = 0;
  if (elapsed > infoAnimator.duration) elapsed = infoAnimator.duration;
  
  // 経過時間がdurationを超えている場合、アニメーションを終了します
  if (elapsed >= infoAnimator.duration) {
    // アニメーションを停止します
    infoButtonStopAnimate();
    // opacityを最終値に設定します
    infoAnimator.currentValue = infoAnimator.toValue;
  }
  // アニメーションを行います
  else {
    // 経過時間からopacityの増分を計算します
    var scale = 0.5 - (0.5 * Math.cos(Math.PI * elapsed / infoAnimator.duration));
    infoAnimator.currentValue = infoButtonComputeNextFloat (infoAnimator.fromValue, infoAnimator.toValue, scale);
  }
  
  // 'i'画像のボタンにopacityを設定します
  infoButton.style.opacity = infoAnimator.currentValue;
}

// opacityの増分を計算します
function infoButtonComputeNextFloat (from, to, ease) {
    return from + (to - from) * ease;
}

//------------------------------------//
// Info rollie button
//------------------------------------//

var infoRollieButton = null;

// バックの丸画像ボタンを作ります
function createInfoRollieButton(div, color) {
  // スタイルを設定します
  var backgroundUrl = "file:///System/Library/WidgetResources/ibutton/" + color + "_rollie.png";
  div.setAttribute("style", "opacity: 0.0; background: url(" + backgroundUrl + ") no-repeat top left;");
  
  // イベントハンドラを設定します
  div.addEventListener("mouseover", infoRollieButtonMouseOver, true);
  div.addEventListener("mouseout", infoRollieButtonMouseOut, true);
  
  // 渡されたノードを保持します
  infoRollieButton = div;
}

// マウスが入ってきたときのイベントハンドラです
function infoRollieButtonMouseOver(event) {
  // opacityを設定して、丸画像を表示します
  infoRollieButton.style.opacity = "0.15";
}

// マウスが出ていくときのイベントハンドラです
function infoRollieButtonMouseOut(event) {
  // opacityを設定して、丸画像を隠します
  infoRollieButton.style.opacity = "0.0";
}
